function main() {

	var rt_server_test_mode = false; // whether we poll the production server API or localhost
	var dfs_server_test_mode = false; // whether we use our fakes for getting CSV

	var current_stage = '';
	var auth_token = null;
	var auth_email = null;

	var upload_override = null;
	var chunk_upload = false;
	var chunk_size = 50000;
	var fanduel_id = null;

	var $mm = $('.stage.main-menu');
	var sync_site;


	var $footer = $('footer');

	var test_server = 'http://rtlocal.com:8000/api/';
	var prod_server = 'https://rototracker.com/api/';
	var rt_api = {
		root: rt_server_test_mode ? test_server : prod_server,
		settings: 'settings/',
		posthistory: 'entryhistory/post/',
		lastlines: 'lastlines/[siteid]/',
		status: 'queuestatus/[siteid]/',
		tokenauth: 'token/auth/',
		tokenrefresh: 'token/refresh/',
		tokenverify: 'token/verify/'
	};

	var sites = {
		dk: {
			id: 'dk',
			name: 'DraftKings',
			csv_url: 'https://www.draftkings.com/mycontests/historycsv?sortField=ContestEndDate&sortOrder=Desc&searchTerm=',
			login_url: 'https://www.draftkings.com/account/sitelogin',
			test_csv_url: 'https://www.draftkings.com/mycontests/historycsv?sortField=ContestEndDate&sortOrder=Desc&searchTerm=',
			header: '"Sport","Game_Type","Entry_Key","Entry","Contest_Key","Contest_Date_EST","Place","Points","Winnings_Non_Ticket","Winnings_Ticket","Contest_Entries","Entry_Fee","Prize_Pool","Places_Paid"'
		},
		fd: {
			id: 'fd',
			name: 'FanDuel',
			csv_url: 'https://www.fanduel.com/pg/MyContests/showCSV/[userid]/1/[start]/[page_size]',
			login_url: 'https://www.fanduel.com/login',
			page_size: dfs_server_test_mode ? 100000 : 250,
			header: 'Entry Id,Sport,Date,Title,SalaryCap,Score,Opp Score,Position,Entries,Opponent,Entry ($),Winnings ($),Link',
			test_csv_url: (dfs_server_test_mode ? test_server : prod_server) + 'extensiontest/fd/[start]/'
		},
		yh: {
			id: 'yh',
			name: 'Yahoo',
			csv_url: 'https://dfyql-ro.sports.yahoo.com/v2/export/userContestHistory',
			login_url: 'https://login.yahoo.com/config/login',
			header_old: 'Start Date,Sport,Id,Title,Entry Id,Status,Entry Fee,Winnings,Points,Rank,Entry Count,Entry Limit',
			header_group_id: 'Start Date,Sport,Id,Group Id,Title,Entry Id,Status,Entry Fee,Winnings,Points,Rank,Entry Count,Entry Limit',
			header: 'Start Date,Sport,Id,League Id,Title,Entry Id,Status,Entry Fee,Winnings,Points,Rank,Entry Count,Entry Limit',
			test_csv_url: (dfs_server_test_mode ? test_server : prod_server) + 'extensiontest/yh/later/'
		}
	};

	// simple switch in for our API to effect all API code
	if (dfs_server_test_mode) {
		sites.dk.csv_url = sites.dk.test_csv_url;
		sites.fd.csv_url = sites.fd.test_csv_url;
		sites.yh.csv_url = sites.yh.test_csv_url;
	}

	// http://stackoverflow.com/questions/15900485/correct-way-to-convert-size-in-bytes-to-kb-mb-gb-in-javascript
	function formatBytes(bytes, decimals) {
		if(bytes == 0) return '0 Byte';
		var k = 1000;
		var dm = decimals + 1 || 3;
		var sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
		var i = Math.floor(Math.log(bytes) / Math.log(k));
		return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + sizes[i];
	}


	// time ago function
	function time_ago(time){
		switch (typeof time) {
			case 'number': break;
			case 'string': time = +new Date(time); break;
			case 'object': if (time.constructor === Date) time = time.getTime(); break;
			default: time = +new Date();
		}
		var time_formats = [
			[60, 'seconds', 1], // 60
			[120, '1 minute ago', '1 minute from now'], // 60*2
			[3600, 'minutes', 60], // 60*60, 60
			[7200, '1 hour ago', '1 hour from now'], // 60*60*2
			[86400, 'hours', 3600], // 60*60*24, 60*60
			[172800, 'Yesterday', 'Tomorrow'], // 60*60*24*2
			[604800, 'days', 86400], // 60*60*24*7, 60*60*24
			[1209600, 'Last week', 'Next week'], // 60*60*24*7*4*2
			[2419200, 'weeks', 604800], // 60*60*24*7*4, 60*60*24*7
			[4838400, 'Last month', 'Next month'], // 60*60*24*7*4*2
			[29030400, 'months', 2419200], // 60*60*24*7*4*12, 60*60*24*7*4
			[58060800, 'Last year', 'Next year'], // 60*60*24*7*4*12*2
			[2903040000, 'years', 29030400], // 60*60*24*7*4*12*100, 60*60*24*7*4*12
			[5806080000, 'Last century', 'Next century'], // 60*60*24*7*4*12*100*2
			[58060800000, 'centuries', 2903040000] // 60*60*24*7*4*12*100*20, 60*60*24*7*4*12*100
		];
		var seconds = (+new Date() - time) / 1000,
			token = 'ago', list_choice = 1;

		if (seconds == 0) {
			return 'Just now'
		}
		if (seconds < 0) {
			seconds = Math.abs(seconds);
			token = 'from now';
			list_choice = 2;
		}
		var i = 0, format;
		while (format = time_formats[i++])
			if (seconds < format[0]) {
				if (typeof format[2] == 'string')
					return format[list_choice];
				else
					return Math.floor(seconds / format[2]) + ' ' + format[1] + ' ' + token;
			}
		return time;
	}


	function getApiUrl(api_call) {
		return rt_api.root + rt_api[api_call];
	}

	function showLogin() {
		function _login(email) {
			var $login = $('.stage.login');
			$login.find('.email').val('');
			$login.find('.password').val('');
			$login.find('.btn').text('Sign in').prop('disabled', false);
			$login.find('.error').text('');

			if (email) {
				$login.find('.email').val(email);
			}
			setTheStage('login');
		}
		modalMessage('Getting account status...', false);
		$.ajax({
			url: getApiUrl('settings'),
			dataType: 'json',
			success: function (response) {
				_login(response.account.email);
			},
			error: function () {
				_login();
			}
		})
	}


	function showMainMenu() {
		chrome.storage.local.get(['upload_override', 'chunk_upload', 'fanduel_id'], function(props) {
			upload_override = props['upload_override'];
			fanduel_id = props['fanduel_id'];
			chunk_upload = props['chunk_upload'] || false;
			setTheStage('main-menu');
			buildHTML();
			$('.login-details').html('You are logged in as <strong>' + auth_email + '</strong>');
			$footer.find('ul').show();
		});
	}

	function setTheStage(stage) {
		if (stage !== current_stage) {
			$('.stage').hide();
			$('.stage.' + stage).show();
			current_stage = stage;
			$footer.find('ul').hide();
		}
	}

	function modalMessage(msg, btn) {
		var $msg = $('.modal-message').find('.message');
		$msg.text(msg);
		$('.modal-message').find('.btn').toggle(btn);
		setTheStage('modal-message');
	}

	function syncing(msg, cls) {
		$('<li class="' + (cls || '') + '">' + msg + '</li>').hide().appendTo($mm.find('#' + sync_site.id).find('ul')).show('fast');
		if (cls === 'text-danger') {
			finishSync(false);
		} else if (cls === 'text-success') {
			finishSync(true);
		}
	}

	function syncProgress(msg) {
		var $ul = $mm.find('#' + sync_site.id).find('ul');
		if (!$ul.find('#progress').length) {
			$('<li id="progress"></div>').hide().appendTo($ul).show('fast')
		}
		var $li =  $ul.find('#progress');
		$li.text(msg);
	}


	function reportErrorCode(xhr) {
		var msg = 'An unknown error occurred. If the problem persists, please contact support [err code: ' + xhr.status + ']';
		if (current_stage === 'main-menu') {
			syncing(msg, 'text-danger')
		} else {
			modalMessage(msg, false);
		}
	}

	function promptDfsLogin(site) {
		// we got redirected - prompt user to login.
		syncing( "You need to log in to " + site.name + '! <a href="' + site.login_url + '">Login now &raquo;</a>', 'text-danger');
		finishSync(false);
	}

	// gets a file name baed on current date
	function getFileName(siteName, suffix) {
		var date = new Date();
		return siteName.toLowerCase() + '-ext-' + date.getFullYear() + '-' + date.getMonth() + '-' + date.getDate() + (suffix ? (' (' + suffix + ')') : '') + '.csv';
	}

	function finishSync(sync_successful) {
		if (sync_successful) {
			var props = {};
			props['last_sync_' + sync_site.id] = new Date().getTime();
			chrome.storage.local.set(props);
		}
		var $btn = $('#' + sync_site.id).find('.sync');
		$btn.removeClass('start').addClass('restart').prop('disabled', false).text('OK');
	}

	/* sends the given data to rototracker. Takes a 'data' dict which
	 should contain header, lines and site. */
	function postToRotoTracker(data) {

		function sendData(header, lines, filename, msg, callback) {
			$.ajax({
				type: "POST",
				dataType: 'json',
				url: getApiUrl('posthistory'),
				data: {
					name: filename,
					data: header + '\n' + lines.join('\n')
				},
				headers: { 'Authorization': 'JWT ' + auth_token },
				xhr: function() {
					var xhr = new window.XMLHttpRequest();
					xhr.upload.addEventListener("progress", function(evt){
						if (evt.lengthComputable) {
							var percentComplete = 100 * evt.loaded / evt.total;
							syncProgress(msg + ' (' + formatBytes(evt.loaded, 1) + ' of ' + formatBytes(evt.total, 1) + ', ' + parseInt(percentComplete, 10) + '%)');
						}
					}, false);
					return xhr;
				},
				success: callback,
				error: reportErrorCode
			})
		}

		function sendChunks(data, counter, total_chunks) {
			var chunk = data.lines.splice(-chunk_size, chunk_size);
			sendData(data.header, chunk, getFileName(data.site.name, counter), 'Uploading part ' + counter + ' of ' + total_chunks, function() {
				if (data.lines.length) {
					sendChunks(data, counter + 1, total_chunks);
				} else {
					syncing(total_chunks + ' files uploaded successfully!', 'text-success');
				}
			});
		}

		if (!data.lines.length) {
			syncing('You\'re all up to date!', 'text-success');
			return;
		}

		if (!chunk_upload || data.lines.length < chunk_size) {
			// Add a pause here before syncing so display updates
			setTimeout(function() {
				syncing('Starting upload...');
			})

			setTimeout(function() {
				sendData(data.header, data.lines, getFileName(data.site.name), 'Uploading ' + data.lines.length.toString() + ' entries', function() {
					syncing(data.lines.length.toString() + ' entries uploaded successfully!', 'text-success');
				});
			}, 0);

		} else {
			sendChunks(data, 1, Math.ceil(data.lines.length / chunk_size));
		}
	}

	// very simple check of HTML <title> attribute to see if we've landed in a login page
	function isLoginPage(url, html) {
		return url.indexOf('/login') !== -1 || /<title>\s*(Sign In|Login)/.test(html);
	}

	// Get's the response from the URL, prompting user to login if necccessary
	function getURL(site, url, callback) {
		$.ajax({
			url: url,
			success: function (response, status, xhr) {
				if (isLoginPage(xhr.responseURL, response) || (site.id == 'yh' && response === '')) {
					promptDfsLogin(site);
				} else {
					callback(response, site.name);
				}
			},
			error: function(xhr) {
				if (xhr.status === 403) {
					promptDfsLogin(site);
				} else {
					reportErrorCode(xhr);
				}
			}
		})
	}

	function getNewLinesFromFile(csvdata, lastlines, site, line_count_so_far) {
		var lines = csvdata.split(/\r\n|\r|\n/);
		line_count_so_far = line_count_so_far || 0;


		// pop off header and check it's as expected.
		var header = lines.shift();
		if (!dfs_server_test_mode && header !== site.header && (header !== site.header + ',')) {
			modalMessage('Unrecognized response! <textarea>' + csvdata + '</textarea>]', true);
			return
		}
		// loop through lines, checking for matches to latest lines.
		var reverse = (site.id === 'yh');
		var newlines = [];
		if (reverse) {
			lines.reverse();
		}
		for (var i=0, len=lines.length; i < len; i++) {
			if (upload_override && (line_count_so_far + newlines.length) >= upload_override && (site.id === 'fd' || site.id === 'yh')) {
				break
			}
			var line = lines[i];
			if (lastlines.indexOf(line) > -1) {
				syncing('Line ' + (i + 1).toString() + ' matches existing contest.');
				break
			} else if (line) {
				if (reverse) {
					newlines.unshift(line);
				} else {
					newlines.push(line);
				}
			}
		}
		return {
			site: site,
			lines: newlines,
			header: header
		};
	}

	// retrieves the data from CSV url and sends it to RT
	function getAndPostCSV(site, lastlines) {
		syncing('Retrieving data from ' + site.name + '...');
		getURL(site, site.csv_url, function(data) {
			if (site.name === 'DraftDay' && /\<title\>\s*My DraftDay Games/.test(data)) {
				// draft day can require a second attempt - first in a session redirects to HTML page
				getURL(site, site.csv_url, function(data2) {
					postToRotoTracker(getNewLinesFromFile(data2, lastlines, site));
				});
			} else {
				postToRotoTracker(getNewLinesFromFile(data, lastlines, site));
			}
		});
	}

	function getAndPostFanDuelCSV(user_id, lastlines) {
		var newdata = undefined;
		var site = sites.fd;

		function getFanDuelURL(index, callback) {
			var url = site.csv_url.replace('[userid]', user_id).replace('[start]', index.toString()).replace('[page_size]', site.page_size.toString());
			syncing('Getting FanDuel data (entries ' + (index + 1) + '-' + (index + site.page_size) + ')...');
			getURL(site, url, callback);
		}

		function getFanDuelPage(index) {
			getFanDuelURL(index, function(csvdata) {

				data = getNewLinesFromFile(csvdata, lastlines, site, newdata && newdata.lines.length);

				// append it to our running tally
				if (newdata === undefined) {
					newdata = data;
				} else {
					newdata.lines.push.apply(newdata.lines, data.lines);
				}

				// if we maxed out the lines of this file for the page, get another page
				if (data.lines.length == site.page_size) {
					getFanDuelPage(index + site.page_size);
				} else {
					postToRotoTracker(newdata);
				}
			});
		}

		// start with first results
		getFanDuelPage(0);
	}

	function getLastLines(site_id, callback) {
		if ((site_id == 'fd' || site_id == 'yh') && upload_override) {
			callback([]);
		} else {
			syncing('Getting last upload...');
			$.ajax({
				url: getApiUrl('lastlines').replace('[siteid]', site_id),
				dataType: 'json',
				headers: {
					'Authorization': 'JWT ' + auth_token
				},
				success: callback,
				error: reportErrorCode
			})
		}

	}


	function getQueueStatus(site_id, callback) {
		syncing('Checking queue status...');
		$.ajax({
			dataType: 'json',
			url: getApiUrl('status').replace('[siteid]', site_id),
			headers: {
				'Authorization': 'JWT ' + auth_token
			},
			success: callback,
			error: reportErrorCode
		})
	}



	/* CSV FETCHING AND UPLOADING --------------------
	 * ------------------------------------------------*/
	/*
	 When a user clicks a site:
	 - Poll RT API to get queue status, if busy then fail
	 - Poll RT API to get latest lines
	 - Poll given site to get latest CSV
	 - Send new lines to RT API
	 */

	// clicking a Sync button
	$('.main-menu').on('click', '.sync.restart', function() {
		$mm.find('#' + sync_site.id).hide();
		sync_site = undefined;
		buildHTML();

	});

	$('.main-menu').on('click', '.gotoSettings', showSettings)

	function prepSync(site_id) {
		sync_site = sites[site_id];
		var $btn = $mm.find('#' + site_id).find('.sync');
		$btn.text('Processing...');
		$btn.prop('disabled', true);
		$('.sites').find('.list-group-item').not('#' + site_id).hide();
		var $site = $('.sites').find('#' + site_id);
		$site.show().find('ul').remove();
		$('<ul></ul>').appendTo($site);
	}

	$('.main-menu').on('click', '.sync.start', function() {

		var site_id = $(this).closest('li').attr('id');
		prepSync(site_id);

		if (site_id === 'dk') {
			syncing('Make sure you are logged in on DraftKings.com (<a target="_blank" href="' + sync_site.login_url + '">go here to log in</a>)');
			syncing('<a href="' + sync_site.csv_url + '" class="btn btn-success">Right click on me and click "Save Link As..."</a> to save your CSV file.');
			syncing('Once downloaded, drag the file from the download bar to here!');
			syncing('Not sure how? <a target="_blank" href="' + window.sync_config.draftkings_gif + '">View an animation of this process!</a>');
			$(this).removeClass('start').addClass('restart').prop('disabled', false).text('OK');

		} else {

			syncing('Starting automatic sync...');
			getQueueStatus(site_id, function (data) {
				if (data.busy !== false) {
					syncing('You have a file processing - wait for that to finish first! <a href="https://rototracker.com/tracker/uploads/">View your uploads &raquo;</a>', 'text-danger');
				} else {
					getLastLines(site_id, function (lastlines) {
						if (site_id === 'fd') {
							syncing('Using FanDuel user ID ' + fanduel_id);
							getAndPostFanDuelCSV(fanduel_id, lastlines);
						} else {
							getAndPostCSV(sync_site, lastlines);
						}
					});
				}
			});
		}
	});


	$('.stages').on('click', '.to-main-menu', function() {
		showMainMenu();
	});

	/* SETTINGS ---------------------------------------
	 * ------------------------------------------------*/
	var $settings = $('.settings');
	var $override_val = $('.settings').find('#override-value');
	var $override = $('.settings').find('#override');
	var $chunk_upload = $('.settings').find('#chunk_upload');
	var $download_csv_link = $('.settings').find('#download_csv_link');
	var $currentFanduelID = $('.settings').find('#currentFanduelID');

	function showSettings() {
		setTheStage('settings');
		if (upload_override > 0 && upload_override <= 999999) {
			$override_val.val(upload_override);
			$override.prop('checked', true);
		} else {
			$override_val.val(500);
			$override.prop('checked', false);
		}
		$chunk_upload.prop('checked', chunk_upload);
		$override.trigger('change');

		// if we don't have fanduel_id then hide $currentFanduelID
		if (fanduel_id) {
			$currentFanduelID.show().find('strong').text(fanduel_id);
		} else {
			$currentFanduelID.hide();
		}
	}

	$settings.find('.extractFanduelID').on('click', function() {
		let match = $download_csv_link.val().match(/showCSV\/(\d+)/)
		if (match) {
			let fanduel_id = match[1];
			chrome.storage.local.set({
				fanduel_id: fanduel_id
			});
			showMainMenu();
		} else {
			alert(`We couldn't detect a Fanduel ID from this link. Please check the instructions and try again. 

The link should look start like this:
https://www.fanduel.com/pg/MyContests/showCSV/...`)
		}
	})

	$settings.find('.save').on('click', function() {
		var val = parseInt($override_val.val(), 10);
		if ($override.prop('checked') && val > 0) {
			if (val > 999999) {
				val = 999999
			}
		} else {
			val = null;
		}

		chrome.storage.local.set({
			upload_override: val,
			chunk_upload: $chunk_upload.prop('checked')
		});
		showMainMenu();
	});

	$override.on('change', function() {
		var isChecked = $override.prop('checked');
		$override_val.prop('disabled', !isChecked);
		$('.indent').toggleClass('muted', !isChecked);
	});


	/* NAVIGATION, LOGIN AND LOGOUT -------------------
	 * ------------------------------------------------*/

	var $rtlogin = $('.login');
	var $loginBtn = $rtlogin.find('button');

	// navigate to the stage set in data-stage
	$('a.back').on('click', function() {
		setTheStage($(this).data('stage'));
	});

	$('a.settings').on('click', showSettings);

	// capture any link going to an external page and open
	// in a new tab
	$('body').on('click', 'a[href^=http]', function(e) {
		e.preventDefault();
		chrome.tabs.create({url: $(this).attr('href')});
		return false
	});

	var loginError = function(msg) {
		$rtlogin.find('.error').text(msg);
		$loginBtn.text('Login').prop('disabled', false);
	};

	// On login button click
	$rtlogin.find('button').on('click', function(e) {
		e.preventDefault();

		// get email and pass
		var creds = {
			username: $rtlogin.find('.email').val(),
			password: $rtlogin.find('.password').val()
		};

		if (creds.username === '') {
			loginError('Please enter your email address.');
			return

		} else if (creds.password === '') {
			loginError('Please enter your password.');
			return
		}

		// disable button
		$loginBtn.text('Logging in...').prop('disabled', true);

		// get a web token
		$.ajax({
			type: "POST",
			url: getApiUrl('tokenauth'),
			dataType: 'json',
			data: creds,
			success: function (data) {
				auth_token = data.token;
				auth_email = creds.username;
				chrome.storage.local.set({
					'auth_token': auth_token,
					'auth_email': auth_email
				});
				showMainMenu();
			},
			error: function(xhr) {
				if (xhr.status === 400) {
					$rtlogin.find('.password').val('');
					loginError('Email address or password incorrect. Please check and try again!');
				} else {
					reportErrorCode(xhr);
				}
			}
		});
	});

	// on logout link click
	$('.logout').on('click', function(e) {
		e.preventDefault();
		chrome.storage.local.remove(['auth_token', 'auth_email']);
		showLogin();
	});



	/* SETUP -----------------------------------------
	 * ------------------------------------------------*/
	var buildHTML = function() {
		// create the main menu
		var $ul = $mm.find('.sites');
		var i = 0;
		$ul.empty();
		$.each(sites, function(id, d) {
			var key = 'last_sync_' + id;
			chrome.storage.local.get(key, function(props) {
				setTimeout(function() {
					var ago = (props[key] === undefined) ? 'Never!' : time_ago(props[key]);
					var btn, msg;
					if (id === 'fd' && !fanduel_id) {
						btn = '<button class="gotoSettings btn btn-primary pull-right">Set FanDuel ID &raquo;</button>';
					} else {
						btn = '<button class="sync start btn btn-primary pull-right">Sync Now!</button>';
					}
					msg = '<small>Last sync: ' + ago + '</small>';
					$('<li class="list-group-item" id="' + id + '">' + btn + '<div class="message"><strong>' + d.name + '</strong> ' + msg + '</div>' + '</li>').hide().appendTo($ul).show('fast');
				}, 100 * i);
				i += 1;
			});
		});

		// set the footer
		$footer.find('.version').html('v' + window.sync_config.version);

	};


	var setUpUploader = function() {

		function detectSite(data) {
			// get site based on a text data. This gets top line and checks on header.
			var topLine = data.split(/\r\n|\r|\n/, 1)[0];
			for (var key in sites) {
				if (sites.hasOwnProperty(key)) {
					var header = sites[key].header;
					if (topLine === header || topLine === header + ',') {
						return sites[key]
					}
				}
			}
		}

		function uploadFile(file) {
			var reader = new FileReader();
			reader.onload = function(e) {
				var data = e.target.result;
				var site = detectSite(data);
				if (!site) {
					modalMessage('Could not detect site from file.', true);
					return
				}
				prepSync(site.id);
				getQueueStatus(site.id, function(status) {
					if (status.busy !== false) {
						syncing("You have a file processing - please wait for that to finish!", 'text-danger');
					} else {
						getLastLines(site.id, function(lastlines) {
							postToRotoTracker(getNewLinesFromFile(data, lastlines, site));
						});
					}
				});

			};
			reader.onerror = function(err) {
				modalMessage('Error reading file: ' + err.getMessage(), true);
			};
			try {
				reader.readAsText(file);
			} catch (e) {
				modalMessage('Failed to read text from file.', true);
			}
		}

		function activate(e) {
			e.preventDefault();
			e.dataTransfer.dropEffect = "copy";
			$('.body').addClass('droptarget');
		}

		function deactivate(e) {
			$('.body').removeClass('droptarget');
		}

		function drop(e) {
			e.preventDefault();
			deactivate();
			uploadFile((e.dataTransfer || e.target).files[0]);
		}

		var uploadbox = document.getElementById('uploader');
		window.addEventListener('dragover', activate);
		window.addEventListener("blur", deactivate);
		uploadbox.addEventListener("dragleave", deactivate);
		uploadbox.addEventListener("dragend", deactivate);
		uploadbox.addEventListener("drop", drop);

		// call deactivate to set up default state.
		deactivate();
	};

	var setUp = function() {
		setUpUploader();

		// start at processing
		modalMessage('Connecting...', false);

		// Do we have an API token stored? If so, get it, verify it, and try refreshing it
		chrome.storage.local.get(['auth_token', 'auth_email'], function(props) {

			if (!props.auth_token || !props.auth_email) {
				showLogin();
				return
			}

			// refresh the token. If that works, store and go to main menu
			modalMessage('Authorizing...', false);
			$.ajax({
				type: "POST",
				url: getApiUrl('tokenrefresh'),
				dataType: 'json',
				data: { token: props.auth_token },

				success: function (data) {
					// set local variables and store to DB
					auth_token = data.token;
					auth_email = props.auth_email;
					chrome.storage.local.set({auth_token: auth_token});
					showMainMenu();
				},
				error: function (xhr, err) {
					if (xhr.status === 0 || xhr.status === undefined) {
						modalMessage('Could not reach the RotoTracker authorization server. The system may be offline temporarily for maintenance. Please check back soon!', false);
					} else {
						// we assume refresh failed and prompt for login
						showLogin();
					}
				}
			})
		});
	};

	setUp();
}

document.addEventListener('DOMContentLoaded', function () {
	main();
});
